//
//  PerMonthSalariesViewController.swift
//  We1lAdmin
//
//  Created by omar altayyan on 11/1/18.
//  Copyright © 2018 juger. All rights reserved.
//


import Autotech


class PerMonthSalariesViewController: ATEntityListVC
{
    
    @IBOutlet weak var salariesMonthDatePicker: DatePickerView!
    
    override func viewDidLoad() {
        
        self.embeddingMode = .staticUnSegueableTableOnly

        super.viewDidLoad()
        

        let date = Date.init()

        let calendar = Calendar.current

        let currentYear = calendar.component(.year, from: date)
        
        salariesMonthDatePicker.minYear  = 1970
        
        salariesMonthDatePicker.maxYear = currentYear
        
        salariesMonthDatePicker.monthSelectedTextColor = UIColor.white
        
        salariesMonthDatePicker.yearSelectedTextColor = UIColor.white
        
        
        salariesMonthDatePicker.monthTextColor = UIColor.white
        
        salariesMonthDatePicker.yearTextColor = UIColor.white

        salariesMonthDatePicker.selectToday()
        
        let valueChangedBlock = {
            self.reloadData()
        }
        
        salariesMonthDatePicker.valueChangedBlock = valueChangedBlock

    }
    
    override func getOperationKey() -> String
    {
        return "Per Month Salaries"
    }
    
    override func getCellReuseIdentifier() -> String
    {
        return "perMonthSalariesTableCell"
    }
    
    override func dataRequestEndPointPostfix() -> String
    {
        return perMonthSalariesURLPostfix
    }
    
    override func dataRequestPostDict() -> PostDict
    {
        
        let calendar = Calendar.current
        
        let selectedYear = calendar.component(.year, from: salariesMonthDatePicker.date)
        
        
        let selectedMonth = calendar.component(.month, from: salariesMonthDatePicker.date)
        
        
        return ["Year": "\(selectedYear)",
                "Month": "\(selectedMonth)"]
    }
    
    
}
